/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.configuration.providers;

import com.google.common.annotations.VisibleForTesting;
import java.util.EnumMap;
import java.util.Map;
import org.apache.solr.util.configuration.SSLCredentialProvider;
import org.apache.solr.util.configuration.providers.AbstractSSLCredentialProvider;

public class EnvSSLCredentialProvider
extends AbstractSSLCredentialProvider {
    private Map<String, String> envVars = System.getenv();

    @Override
    protected EnumMap<SSLCredentialProvider.CredentialType, String> getCredentialKeyMap() {
        return new EnumMap<SSLCredentialProvider.CredentialType, String>(Map.of(SSLCredentialProvider.CredentialType.SSL_KEY_STORE_PASSWORD, "SOLR_SSL_KEY_STORE_PASSWORD", SSLCredentialProvider.CredentialType.SSL_TRUST_STORE_PASSWORD, "SOLR_SSL_TRUST_STORE_PASSWORD", SSLCredentialProvider.CredentialType.SSL_CLIENT_KEY_STORE_PASSWORD, "SOLR_SSL_CLIENT_KEY_STORE_PASSWORD", SSLCredentialProvider.CredentialType.SSL_CLIENT_TRUST_STORE_PASSWORD, "SOLR_SSL_CLIENT_TRUST_STORE_PASSWORD"));
    }

    @Override
    protected String getCredential(String envKey) {
        if (this.envVars.containsKey(envKey)) {
            return this.envVars.get(envKey);
        }
        return null;
    }

    @VisibleForTesting
    public void setEnvVars(Map<String, String> envVars) {
        this.envVars = envVars;
    }

    public static class EnvVars {
        public static final String SOLR_SSL_CLIENT_KEY_STORE_PASSWORD = "SOLR_SSL_CLIENT_KEY_STORE_PASSWORD";
        public static final String SOLR_SSL_KEY_STORE_PASSWORD = "SOLR_SSL_KEY_STORE_PASSWORD";
        public static final String SOLR_SSL_CLIENT_TRUST_STORE_PASSWORD = "SOLR_SSL_CLIENT_TRUST_STORE_PASSWORD";
        public static final String SOLR_SSL_TRUST_STORE_PASSWORD = "SOLR_SSL_TRUST_STORE_PASSWORD";
    }
}

