/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.util.ArrayList;
import java.util.List;
import org.apache.solr.cloud.DistributedCollectionLockFactory;
import org.apache.solr.cloud.DistributedLock;
import org.apache.solr.cloud.DistributedMultiLock;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.CollectionParams;

public class CollectionApiLockFactory {
    private final DistributedCollectionLockFactory lockFactory;

    CollectionApiLockFactory(DistributedCollectionLockFactory lockFactory) {
        this.lockFactory = lockFactory;
    }

    DistributedMultiLock createCollectionApiLock(CollectionParams.LockLevel lockLevel, String collName, String shardId, String replicaName) {
        if (lockLevel == CollectionParams.LockLevel.NONE) {
            return new DistributedMultiLock(List.of());
        }
        if (lockLevel == CollectionParams.LockLevel.CLUSTER) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Bug. Not expecting locking at cluster level.");
        }
        if (collName == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Bug. collName can't be null");
        }
        if (lockLevel == CollectionParams.LockLevel.SHARD && shardId == null) {
            shardId = "MadeUpShardNameWhenNoShardNameWasProvided";
        }
        boolean requestWriteLock = true;
        CollectionParams.LockLevel[] iterationOrder = new CollectionParams.LockLevel[]{CollectionParams.LockLevel.REPLICA, CollectionParams.LockLevel.SHARD, CollectionParams.LockLevel.COLLECTION};
        ArrayList<DistributedLock> locks = new ArrayList<DistributedLock>(iterationOrder.length);
        for (CollectionParams.LockLevel level : iterationOrder) {
            if (!lockLevel.isHigherOrEqual(level)) continue;
            locks.add(this.lockFactory.createLock(requestWriteLock, level, collName, shardId, replicaName));
            requestWriteLock = false;
        }
        return new DistributedMultiLock(locks);
    }
}

