/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.MultiSearchRequest;
import org.opensearch.action.search.MultiSearchResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.ad.transport.SearchAnomalyResultAction;
import org.opensearch.ad.transport.handler.ADSearchHandler;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.query.MatchAllQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.bucket.terms.StringTerms;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class SearchAnomalyResultTransportAction
extends HandledTransportAction<SearchRequest, SearchResponse> {
    public static final String RESULT_INDEX_AGG_NAME = "result_index";
    private final Logger logger = LogManager.getLogger(SearchAnomalyResultTransportAction.class);
    private ADSearchHandler searchHandler;
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final Client client;

    @Inject
    public SearchAnomalyResultTransportAction(TransportService transportService, ActionFilters actionFilters, ADSearchHandler searchHandler, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver, Client client) {
        super(SearchAnomalyResultAction.NAME, transportService, actionFilters, SearchRequest::new);
        this.searchHandler = searchHandler;
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.client = client;
    }

    @VisibleForTesting
    boolean validateIndexAndReturnOnlyQueryCustomResult(String[] indices) {
        if (indices == null || indices.length == 0) {
            throw new IllegalArgumentException("No indices set in search request");
        }
        boolean onlyQueryCustomResultIndex = true;
        for (String indexName : indices) {
            if (!".opendistro-anomaly-results*".equals(indexName)) continue;
            onlyQueryCustomResultIndex = false;
        }
        return onlyQueryCustomResultIndex;
    }

    @VisibleForTesting
    void calculateCustomResultIndices(Set<String> customResultIndices, String[] indices) {
        String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(this.clusterService.state(), IndicesOptions.lenientExpandOpen(), indices);
        if (concreteIndices != null) {
            for (String index : concreteIndices) {
                if (!index.startsWith("opensearch-ad-plugin-result-")) continue;
                customResultIndices.add(index);
            }
        }
    }

    @VisibleForTesting
    SearchRequest createSingleSearchRequest() {
        SearchSourceBuilder searchResultIndexBuilder = new SearchSourceBuilder();
        TermsAggregationBuilder aggregation = ((TermsAggregationBuilder)new TermsAggregationBuilder(RESULT_INDEX_AGG_NAME).field(RESULT_INDEX_AGG_NAME)).size(10000);
        searchResultIndexBuilder.aggregation((AggregationBuilder)aggregation).size(0);
        return new SearchRequest(new String[]{".opendistro-anomaly-detectors"}).source(searchResultIndexBuilder);
    }

    @VisibleForTesting
    void processSingleSearchResponse(SearchResponse allResultIndicesResponse, SearchRequest request, ActionListener<SearchResponse> listener, Set<String> customResultIndices, List<String> targetIndices) {
        Aggregations aggregations = allResultIndicesResponse.getAggregations();
        StringTerms resultIndicesAgg = (StringTerms)aggregations.get(RESULT_INDEX_AGG_NAME);
        List buckets = resultIndicesAgg.getBuckets();
        HashSet resultIndicesOfDetector = new HashSet();
        if (buckets == null) {
            this.searchHandler.search(request, listener);
            return;
        }
        buckets.stream().forEach(b -> resultIndicesOfDetector.add(b.getKeyAsString()));
        for (String index : customResultIndices) {
            if (!resultIndicesOfDetector.contains(index)) continue;
            targetIndices.add(index);
        }
        if (targetIndices.size() == 0) {
            this.searchHandler.search(request, listener);
            return;
        }
    }

    @VisibleForTesting
    MultiSearchRequest createMultiSearchRequest(List<String> targetIndices) {
        MultiSearchRequest multiSearchRequest = new MultiSearchRequest();
        for (String index : targetIndices) {
            multiSearchRequest.add(new SearchRequest(new String[]{index}).source(new SearchSourceBuilder().query((QueryBuilder)new MatchAllQueryBuilder()).size(0)));
        }
        return multiSearchRequest;
    }

    @VisibleForTesting
    void multiSearch(List<String> targetIndices, SearchRequest request, ActionListener<SearchResponse> listener, boolean finalOnlyQueryCustomResultIndex, ThreadContext.StoredContext context) {
        if (targetIndices.size() == 0) {
            return;
        }
        MultiSearchRequest multiSearchRequest = this.createMultiSearchRequest(targetIndices);
        ArrayList<String> readableIndices = new ArrayList<String>();
        if (!finalOnlyQueryCustomResultIndex) {
            readableIndices.add(".opendistro-anomaly-results*");
        }
        context.restore();
        this.client.multiSearch(multiSearchRequest, ActionListener.wrap(multiSearchResponse -> this.processMultiSearchResponse((MultiSearchResponse)multiSearchResponse, targetIndices, (List<String>)readableIndices, request, listener), multiSearchException -> {
            this.logger.error("Failed to search custom AD result indices", (Throwable)multiSearchException);
            listener.onFailure(multiSearchException);
        }));
    }

    @VisibleForTesting
    void processMultiSearchResponse(MultiSearchResponse multiSearchResponse, List<String> targetIndices, List<String> readableIndices, SearchRequest request, ActionListener<SearchResponse> listener) {
        MultiSearchResponse.Item[] responses = multiSearchResponse.getResponses();
        for (int i = 0; i < responses.length; ++i) {
            MultiSearchResponse.Item item = responses[i];
            String indexName = targetIndices.get(i);
            if (item.getFailure() != null) continue;
            readableIndices.add(indexName);
        }
        if (readableIndices.size() == 0) {
            listener.onFailure((Exception)new IllegalArgumentException("No readable custom result indices found"));
            return;
        }
        request.indices(readableIndices.toArray(new String[0]));
        this.searchHandler.search(request, listener);
    }

    @VisibleForTesting
    void searchADResultIndex(SearchRequest request, ActionListener<SearchResponse> listener, boolean onlyQueryCustomResultIndex, Set<String> customResultIndices) {
        SearchRequest searchResultIndex = this.createSingleSearchRequest();
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            boolean finalOnlyQueryCustomResultIndex = onlyQueryCustomResultIndex;
            this.client.search(searchResultIndex, ActionListener.wrap(allResultIndicesResponse -> {
                ArrayList<String> targetIndices = new ArrayList<String>();
                this.processSingleSearchResponse((SearchResponse)allResultIndicesResponse, request, listener, customResultIndices, (List<String>)targetIndices);
                this.multiSearch(targetIndices, request, listener, finalOnlyQueryCustomResultIndex, context);
            }, e -> {
                this.logger.error("Failed to search result indices for all detectors", (Throwable)e);
                listener.onFailure(e);
            }));
        }
        catch (Exception e2) {
            this.logger.error((Object)e2);
            listener.onFailure(e2);
        }
    }

    protected void doExecute(Task task, SearchRequest request, ActionListener<SearchResponse> listener) {
        boolean onlyQueryCustomResultIndex;
        HashSet<String> customResultIndices = new HashSet<String>();
        try {
            onlyQueryCustomResultIndex = this.validateIndexAndReturnOnlyQueryCustomResult(request.indices());
            this.calculateCustomResultIndices(customResultIndices, request.indices());
            if (onlyQueryCustomResultIndex && customResultIndices.size() == 0) {
                throw new IllegalArgumentException("No custom result indices found");
            }
        }
        catch (IllegalArgumentException exception) {
            listener.onFailure((Exception)exception);
            return;
        }
        if (customResultIndices.size() == 0) {
            request.indices(new String[]{".opendistro-anomaly-results*"});
            this.searchHandler.search(request, listener);
            return;
        }
        this.searchADResultIndex(request, listener, onlyQueryCustomResultIndex, customResultIndices);
    }
}

