/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.net.ssl.SSLHandshakeException;
import sun.security.provider.certpath.OCSPResponse;
import sun.security.ssl.Alert;
import sun.security.ssl.CertStatusExtension;
import sun.security.ssl.CertificateMessage;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.HandshakeAbsence;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.Record;
import sun.security.ssl.SSLConsumer;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.StatusResponseManager;
import sun.security.ssl.Utilities;

final class CertificateStatus {
    static final SSLConsumer handshakeConsumer = new CertificateStatusConsumer();
    static final HandshakeProducer handshakeProducer = new CertificateStatusProducer();
    static final HandshakeAbsence handshakeAbsence = new CertificateStatusAbsence();

    CertificateStatus() {
    }

    private static final class CertificateStatusAbsence
    implements HandshakeAbsence {
        private CertificateStatusAbsence() {
        }

        @Override
        public void absent(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            if (clientHandshakeContext.staplingActive) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Server did not send CertificateStatus, checking cert chain without status info.", new Object[0]);
                }
                CertificateMessage.T12CertificateConsumer.checkServerCerts(clientHandshakeContext, clientHandshakeContext.deferredCerts);
            }
        }
    }

    private static final class CertificateStatusProducer
    implements HandshakeProducer {
        private CertificateStatusProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            if (!serverHandshakeContext.staplingActive) {
                return null;
            }
            CertificateStatusMessage certificateStatusMessage = new CertificateStatusMessage(serverHandshakeContext);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced server CertificateStatus handshake message", certificateStatusMessage);
            }
            certificateStatusMessage.write(serverHandshakeContext.handshakeOutput);
            serverHandshakeContext.handshakeOutput.flush();
            return null;
        }
    }

    private static final class CertificateStatusConsumer
    implements SSLConsumer {
        private CertificateStatusConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            CertificateStatusMessage certificateStatusMessage = new CertificateStatusMessage(clientHandshakeContext, byteBuffer);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming server CertificateStatus handshake message", certificateStatusMessage);
            }
            clientHandshakeContext.handshakeSession.setStatusResponses(certificateStatusMessage.encodedResponses);
            CertificateMessage.T12CertificateConsumer.checkServerCerts(clientHandshakeContext, clientHandshakeContext.deferredCerts);
            clientHandshakeContext.handshakeConsumers.remove(SSLHandshake.CERTIFICATE_STATUS.id);
        }
    }

    static final class CertificateStatusMessage
    extends SSLHandshake.HandshakeMessage {
        final CertStatusExtension.CertStatusRequestType statusType;
        int encodedResponsesLen = 0;
        int messageLength = -1;
        final List<byte[]> encodedResponses = new ArrayList<byte[]>();

        CertificateStatusMessage(HandshakeContext handshakeContext) {
            super(handshakeContext);
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)handshakeContext;
            StatusResponseManager.StaplingParameters staplingParameters = serverHandshakeContext.stapleParams;
            if (staplingParameters == null) {
                throw new IllegalArgumentException("Unexpected null stapling parameters");
            }
            X509Certificate[] x509CertificateArray = (X509Certificate[])serverHandshakeContext.handshakeSession.getLocalCertificates();
            if (x509CertificateArray == null) {
                throw new IllegalArgumentException("Unexpected null certificate chain");
            }
            this.statusType = staplingParameters.statReqType;
            if (this.statusType == CertStatusExtension.CertStatusRequestType.OCSP) {
                byte[] byArray = staplingParameters.responseMap.get(x509CertificateArray[0]);
                if (byArray == null) {
                    byArray = new byte[]{};
                }
                this.encodedResponses.add(byArray);
                this.encodedResponsesLen += byArray.length + 3;
            } else if (this.statusType == CertStatusExtension.CertStatusRequestType.OCSP_MULTI) {
                for (X509Certificate x509Certificate : x509CertificateArray) {
                    byte[] byArray = staplingParameters.responseMap.get(x509Certificate);
                    if (byArray == null) {
                        byArray = new byte[]{};
                    }
                    this.encodedResponses.add(byArray);
                    this.encodedResponsesLen += byArray.length + 3;
                }
            } else {
                throw new IllegalArgumentException("Unsupported StatusResponseType: " + (Object)((Object)this.statusType));
            }
            this.messageLength = this.messageLength();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        CertificateStatusMessage(HandshakeContext handshakeContext, ByteBuffer byteBuffer) throws IOException {
            super(handshakeContext);
            this.statusType = CertStatusExtension.CertStatusRequestType.valueOf((byte)Record.getInt8(byteBuffer));
            if (this.statusType == CertStatusExtension.CertStatusRequestType.OCSP) {
                byte[] byArray = Record.getBytes24(byteBuffer);
                if (byArray.length <= 0) throw handshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Zero-length OCSP Response");
                this.encodedResponses.add(byArray);
                this.encodedResponsesLen = 3 + byArray.length;
            } else {
                int n;
                if (this.statusType != CertStatusExtension.CertStatusRequestType.OCSP_MULTI) throw handshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "Unsupported StatusResponseType: " + (Object)((Object)this.statusType));
                this.encodedResponsesLen = n = Record.getInt24(byteBuffer);
                while (n > 0) {
                    byte[] byArray = Record.getBytes24(byteBuffer);
                    this.encodedResponses.add(byArray);
                    n -= byArray.length + 3;
                }
                if (n != 0) {
                    throw handshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Bad OCSP response list length");
                }
            }
            this.messageLength = this.messageLength();
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.CERTIFICATE_STATUS;
        }

        @Override
        public int messageLength() {
            int n = 1;
            if (this.messageLength == -1) {
                if (this.statusType == CertStatusExtension.CertStatusRequestType.OCSP) {
                    n += this.encodedResponsesLen;
                } else if (this.statusType == CertStatusExtension.CertStatusRequestType.OCSP_MULTI) {
                    n += 3 + this.encodedResponsesLen;
                }
                this.messageLength = n;
            }
            return this.messageLength;
        }

        @Override
        public void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.putInt8(this.statusType.id);
            if (this.statusType == CertStatusExtension.CertStatusRequestType.OCSP) {
                handshakeOutStream.putBytes24(this.encodedResponses.get(0));
            } else if (this.statusType == CertStatusExtension.CertStatusRequestType.OCSP_MULTI) {
                handshakeOutStream.putInt24(this.encodedResponsesLen);
                for (byte[] byArray : this.encodedResponses) {
                    if (byArray != null) {
                        handshakeOutStream.putBytes24(byArray);
                        continue;
                    }
                    handshakeOutStream.putBytes24(null);
                }
            } else {
                throw new SSLHandshakeException("Unsupported status_type: " + this.statusType.id);
            }
        }

        public String toString() {
            Object[] objectArray2;
            StringBuilder stringBuilder = new StringBuilder();
            for (Object[] objectArray2 : this.encodedResponses) {
                if (objectArray2.length > 0) {
                    try {
                        OCSPResponse oCSPResponse = new OCSPResponse((byte[])objectArray2);
                        stringBuilder.append(oCSPResponse.toString()).append("\n");
                    }
                    catch (IOException iOException) {
                        stringBuilder.append("OCSP Response Exception: ").append(iOException).append("\n");
                    }
                    continue;
                }
                stringBuilder.append("<Zero-length entry>\n");
            }
            MessageFormat messageFormat = new MessageFormat("\"CertificateStatus\": '{'\n  \"type\"                : \"{0}\",\n  \"responses \"          : [\n{1}\n  ]\n'}'", Locale.ENGLISH);
            objectArray2 = new Object[]{this.statusType.name, Utilities.indent(Utilities.indent(stringBuilder.toString()))};
            return messageFormat.format(objectArray2);
        }
    }
}

