/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.config;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jnlp.config.Defaults;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.FileUtils;
import net.sourceforge.jnlp.util.logging.OutputController;

public class DirectoryValidator {
    private final List<File> dirsToCheck;

    public DirectoryValidator(List<File> dirsToCheck) {
        this.dirsToCheck = dirsToCheck;
    }

    public DirectoryValidator() {
        String[] keys;
        this.dirsToCheck = new ArrayList<File>(6);
        DeploymentConfiguration dc = JNLPRuntime.getConfiguration();
        for (String key : keys = new String[]{"deployment.user.cachedir", "deployment.user.pcachedir", "deployment.system.cachedir", "deployment.user.logdir", "deployment.user.tmp", "deployment.user.locksdir"}) {
            String value = dc.getProperty(key);
            if (value == null) {
                OutputController.getLogger().log(OutputController.Level.MESSAGE_DEBUG, "WARNING: key " + key + " has no value, setting to default value");
                value = Defaults.getDefaults().get(key).getValue();
            }
            if (value == null) {
                if (!JNLPRuntime.isDebug()) continue;
                OutputController.getLogger().log(OutputController.Level.MESSAGE_DEBUG, "WARNING: key " + key + " has no value, skipping");
                continue;
            }
            File f = new File(value);
            this.dirsToCheck.add(f);
        }
    }

    public DirectoryCheckResults ensureDirs() {
        return DirectoryValidator.ensureDirs(this.dirsToCheck);
    }

    static DirectoryCheckResults ensureDirs(List<File> dirs) {
        ArrayList<DirectoryCheckResult> result = new ArrayList<DirectoryCheckResult>(dirs.size());
        for (File f : dirs) {
            DirectoryCheckResult r;
            if (f.exists()) {
                r = DirectoryValidator.testDir(f, true, true);
                result.add(r);
                continue;
            }
            if (!f.mkdirs()) {
                OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "ERROR: Directory " + f.getAbsolutePath() + " does not exist and has not been created");
            } else {
                OutputController.getLogger().log(OutputController.Level.MESSAGE_DEBUG, "OK: Directory " + f.getAbsolutePath() + " did not exist but has been created");
            }
            r = DirectoryValidator.testDir(f, true, true);
            result.add(r);
        }
        return new DirectoryCheckResults(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DirectoryCheckResult testDir(File f, boolean verbose, boolean testSubdir) {
        DirectoryCheckResult result = new DirectoryCheckResult(f);
        if (!f.exists()) {
            if (verbose) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, DirectoryCheckResult.notExistsMessage(f));
            }
            result.exists = false;
        }
        if (!f.isDirectory()) {
            if (verbose) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, DirectoryCheckResult.notDirMessage(f));
            }
            result.isDir = false;
        }
        File testFile = null;
        boolean correctPermissions = true;
        try {
            testFile = File.createTempFile("maindir", "check", f);
            if (!testFile.exists()) {
                correctPermissions = false;
            }
            try {
                FileUtils.saveFile("ww", testFile);
                String s = FileUtils.loadFileAsString(testFile);
                if (!s.trim().equals("ww")) {
                    correctPermissions = false;
                }
            }
            catch (Exception ex) {
                if (JNLPRuntime.isDebug()) {
                    ex.printStackTrace();
                }
                correctPermissions = false;
            }
            File[] canList = f.listFiles();
            if (canList == null || canList.length == 0) {
                correctPermissions = false;
            }
            testFile.delete();
            if (testFile.exists()) {
                correctPermissions = false;
            } else {
                boolean created = testFile.mkdir();
                if (!created) {
                    correctPermissions = false;
                }
                if (testFile.exists()) {
                    if (testSubdir) {
                        DirectoryCheckResult subdirResult = DirectoryValidator.testDir(testFile, verbose, false);
                        if (subdirResult.getFailures() != 0) {
                            result.subDir = subdirResult;
                            correctPermissions = false;
                        }
                        testFile.delete();
                        if (testFile.exists()) {
                            correctPermissions = false;
                        }
                    }
                } else {
                    correctPermissions = false;
                }
            }
        }
        catch (Exception ex) {
            if (JNLPRuntime.isDebug()) {
                ex.printStackTrace();
            }
            correctPermissions = false;
        }
        finally {
            if (testFile != null && testFile.exists()) {
                testFile.delete();
            }
        }
        if (!correctPermissions) {
            if (verbose) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, DirectoryCheckResult.wrongPermissionsMessage(f));
            }
            result.correctPermissions = false;
        }
        return result;
    }

    public static class DirectoryCheckResult {
        public boolean exists = true;
        public boolean isDir = true;
        public boolean correctPermissions = true;
        public DirectoryCheckResult subDir = null;
        private final File testedDir;

        public DirectoryCheckResult(File testedDir) {
            this.testedDir = testedDir;
        }

        public static String notExistsMessage(File f) {
            return Translator.R("DCmaindircheckNotexists", f.getAbsolutePath());
        }

        public static String notDirMessage(File f) {
            return Translator.R("DCmaindircheckNotdir", f.getAbsolutePath());
        }

        public static String wrongPermissionsMessage(File f) {
            return Translator.R("DCmaindircheckRwproblem", f.getAbsolutePath());
        }

        private static int booleanToInt(boolean b) {
            if (b) {
                return 1;
            }
            return 0;
        }

        public int getPasses() {
            int subdirs = 0;
            if (this.subDir != null) {
                subdirs = this.subDir.getPasses();
            }
            return DirectoryCheckResult.booleanToInt(this.exists) + DirectoryCheckResult.booleanToInt(this.isDir) + DirectoryCheckResult.booleanToInt(this.correctPermissions) + subdirs;
        }

        public int getFailures() {
            int max = 3;
            if (this.subDir != null) {
                max = 2 * max;
            }
            return max - this.getPasses();
        }

        public String getMessage() {
            String s;
            StringBuilder sb = new StringBuilder();
            if (!this.exists) {
                sb.append(DirectoryCheckResult.notExistsMessage(this.testedDir)).append("\n");
            }
            if (!this.isDir) {
                sb.append(DirectoryCheckResult.notDirMessage(this.testedDir)).append("\n");
            }
            if (!this.correctPermissions) {
                sb.append(DirectoryCheckResult.wrongPermissionsMessage(this.testedDir)).append("\n");
            }
            if (this.subDir != null && !(s = this.subDir.getMessage()).isEmpty()) {
                sb.append(s);
            }
            return sb.toString();
        }

        public String toString() {
            return this.getMessage();
        }
    }

    public static class DirectoryCheckResults {
        public final List<DirectoryCheckResult> results;

        public DirectoryCheckResults(List<DirectoryCheckResult> results) {
            this.results = results;
        }

        public int getPasses() {
            int passes = 0;
            for (DirectoryCheckResult directoryCheckResult : this.results) {
                passes += directoryCheckResult.getPasses();
            }
            return passes;
        }

        public int getFailures() {
            int failures = 0;
            for (DirectoryCheckResult directoryCheckResult : this.results) {
                failures += directoryCheckResult.getFailures();
            }
            return failures;
        }

        public String getMessage() {
            return DirectoryCheckResults.resultsToString(this.results);
        }

        public String toString() {
            return this.getMessage();
        }

        public static String resultsToString(List<DirectoryCheckResult> results) {
            StringBuilder sb = new StringBuilder();
            for (DirectoryCheckResult r : results) {
                if (r.getFailures() <= 0) continue;
                sb.append(r.getMessage());
            }
            return sb.toString();
        }
    }
}

