/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.Dimension;
import io.sf.carte.doc.style.css.parser.DimensionalAnalyzer;
import io.sf.carte.doc.style.css.parser.LexicalUnitImpl;
import org.w3c.dom.DOMException;

class ExpressionUnitImpl
extends LexicalUnitImpl {
    private static final long serialVersionUID = 1L;

    public ExpressionUnitImpl(LexicalUnit.LexicalType type) {
        super(type);
    }

    @Override
    public LexicalUnit getSubValues() {
        return this.parameters;
    }

    @Override
    CharSequence currentToString() {
        return this.functionalSerialization(this.value);
    }

    @Override
    CSSValueSyntax.Match typeMatch(CSSValueSyntax rootSyntax, CSSValueSyntax syntax) {
        CSSValueSyntax.Category cat = syntax.getCategory();
        switch (cat) {
            case integer: 
            case number: 
            case percentage: 
            case lengthPercentage: 
            case length: 
            case angle: 
            case time: 
            case frequency: 
            case resolution: 
            case flex: {
                return this.matchExpression(rootSyntax, syntax);
            }
            case universal: {
                return CSSValueSyntax.Match.TRUE;
            }
        }
        return CSSValueSyntax.Match.FALSE;
    }

    private CSSValueSyntax.Match matchExpression(CSSValueSyntax rootSyntax, CSSValueSyntax syntax) {
        Dimension dim;
        DimensionalAnalyzer danal = new DimensionalAnalyzer();
        try {
            dim = danal.expressionDimension(this.parameters);
        }
        catch (DOMException e) {
            return CSSValueSyntax.Match.FALSE;
        }
        if (dim == null) {
            return CSSValueSyntax.Match.PENDING;
        }
        CSSValueSyntax.Match expected = CSSValueSyntax.Match.FALSE;
        boolean lenghtMatched = false;
        boolean pcntMatched = false;
        CSSValueSyntax comp = rootSyntax;
        do {
            CSSValueSyntax.Match match;
            CSSValueSyntax.Category cat = comp.getCategory();
            boolean lenientLP = danal.isAttrPending();
            if (lenientLP) {
                match = ExpressionUnitImpl.categoryMatch(true, true, dim.category, cat);
                if (match == CSSValueSyntax.Match.PENDING) {
                    if (cat == CSSValueSyntax.Category.length) {
                        lenghtMatched = true;
                        match = dim.isPercentageProcessed() ? CSSValueSyntax.Match.FALSE : CSSValueSyntax.Match.PENDING;
                    } else if (cat == CSSValueSyntax.Category.percentage) {
                        pcntMatched = true;
                        match = dim.isLengthProcessed() ? CSSValueSyntax.Match.FALSE : CSSValueSyntax.Match.PENDING;
                    }
                }
            } else {
                if (cat == CSSValueSyntax.Category.length) {
                    lenghtMatched = true;
                } else if (cat == CSSValueSyntax.Category.percentage) {
                    pcntMatched = true;
                }
                match = ExpressionUnitImpl.categoryMatch(true, false, dim.category, cat);
            }
            if (match == CSSValueSyntax.Match.TRUE) {
                if (!dim.isCSS()) continue;
                return CSSValueSyntax.Match.TRUE;
            }
            if (expected == CSSValueSyntax.Match.PENDING) continue;
            expected = match;
        } while ((comp = comp.getNext()) != null);
        if (dim.category == CSSValueSyntax.Category.lengthPercentage && lenghtMatched && pcntMatched) {
            expected = CSSValueSyntax.Match.TRUE;
        }
        return expected;
    }

    @Override
    ExpressionUnitImpl instantiateLexicalUnit() {
        return new ExpressionUnitImpl(this.getLexicalUnitType());
    }
}

