/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Tension;
import net.sf.freecol.common.util.StringUtils;

public enum Stance implements Named
{
    UNCONTACTED,
    ALLIANCE,
    PEACE,
    CEASE_FIRE,
    WAR;


    private void badStance() {
    }

    private void badTransition(Stance newStance) {
        throw new RuntimeException("Bad transition: " + this + " -> " + newStance);
    }

    public Stance getStanceFromTension(Tension tension) {
        int value = tension.getValue();
        switch (this) {
            case WAR: {
                if (value > Tension.Level.CONTENT.getLimit() - 10) break;
                return CEASE_FIRE;
            }
            case CEASE_FIRE: {
                if (value <= Tension.Level.HAPPY.getLimit() - 10) {
                    return PEACE;
                }
            }
            case ALLIANCE: 
            case PEACE: {
                if (value <= Tension.Level.HATEFUL.getLimit() + 10) break;
                return WAR;
            }
            case UNCONTACTED: {
                break;
            }
            default: {
                this.badStance();
            }
        }
        return this;
    }

    @SuppressFBWarnings(value={"SF_SWITCH_FALLTHROUGH"})
    public int getTensionModifier(Stance newStance) {
        switch (newStance) {
            case UNCONTACTED: {
                this.badTransition(newStance);
                break;
            }
            case ALLIANCE: {
                switch (this) {
                    case UNCONTACTED: {
                        this.badTransition(newStance);
                    }
                    case ALLIANCE: {
                        return 0;
                    }
                    case PEACE: {
                        return -500;
                    }
                    case CEASE_FIRE: {
                        return -750;
                    }
                    case WAR: {
                        return -1000;
                    }
                }
                break;
            }
            case PEACE: {
                switch (this) {
                    case UNCONTACTED: {
                        return 0;
                    }
                    case ALLIANCE: {
                        return 200;
                    }
                    case PEACE: {
                        return 0;
                    }
                    case CEASE_FIRE: {
                        return -250;
                    }
                    case WAR: {
                        return -500;
                    }
                }
                break;
            }
            case CEASE_FIRE: {
                switch (this) {
                    case UNCONTACTED: {
                        this.badTransition(newStance);
                    }
                    case ALLIANCE: {
                        this.badTransition(newStance);
                    }
                    case PEACE: {
                        this.badTransition(newStance);
                    }
                    case CEASE_FIRE: {
                        return 0;
                    }
                    case WAR: {
                        return -250;
                    }
                }
                break;
            }
            case WAR: {
                switch (this) {
                    case UNCONTACTED: {
                        return Tension.WAR_MODIFIER;
                    }
                    case ALLIANCE: {
                        return Tension.WAR_MODIFIER;
                    }
                    case PEACE: {
                        return Tension.WAR_MODIFIER;
                    }
                    case CEASE_FIRE: {
                        return 750;
                    }
                    case WAR: {
                        return 0;
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException("Bogus newStance: " + newStance);
            }
        }
        throw new RuntimeException("Bogus stance: " + this);
    }

    public boolean isIncitable() {
        switch (this) {
            case CEASE_FIRE: 
            case PEACE: {
                return true;
            }
        }
        return false;
    }

    public String getKey() {
        return "stance." + StringUtils.getEnumKey(this);
    }

    public String getStanceChangeKey() {
        return "model.player." + this.getKey() + ".declared";
    }

    public String getOtherStanceChangeKey() {
        return "model.player." + this.getKey() + ".others";
    }

    @Override
    public String getNameKey() {
        return Messages.nameKey("model." + this.getKey());
    }
}

